/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Image;
import jclass.bwt.JCSerializable;
import jclass.chart.Changeable;
import jclass.chart.JCBorderStyle;
import jclass.chart.JCChart;
import jclass.chart.JCFillStyle;
import jclass.chart.JCLineStyle;
import jclass.chart.JCShape;
import jclass.chart.JCSymbolStyle;

public class JCChartStyle
implements JCSerializable {
    JCLineStyle lineStyle;
    JCFillStyle fillStyle;
    JCSymbolStyle symbolStyle;
    JCBorderStyle borderStyle;
    Changeable parent;

    public JCChartStyle(JCLineStyle jCLineStyle, JCFillStyle jCFillStyle, JCSymbolStyle jCSymbolStyle) {
        this.lineStyle = jCLineStyle;
        this.fillStyle = jCFillStyle;
        this.symbolStyle = jCSymbolStyle;
        this.fillStyle.parent = this.symbolStyle.parent = this;
        this.lineStyle.parent = this.symbolStyle.parent;
        this.borderStyle = new JCBorderStyle();
        this.borderStyle.type = 5;
        this.borderStyle.width = 1;
    }

    public JCChartStyle() {
        this.lineStyle = JCLineStyle.makeDefault(null);
        this.fillStyle = JCFillStyle.makeDefault(null);
        this.symbolStyle = JCSymbolStyle.makeDefault(null);
        this.fillStyle.parent = this.symbolStyle.parent = this;
        this.lineStyle.parent = this.symbolStyle.parent;
        this.borderStyle = new JCBorderStyle(null);
        this.borderStyle.type = 5;
        this.borderStyle.width = 1;
    }

    public static JCChartStyle makeDefault(JCChart jCChart) {
        JCChartStyle jCChartStyle = new JCChartStyle(JCLineStyle.makeDefault(jCChart), JCFillStyle.makeDefault(jCChart), JCSymbolStyle.makeDefault(jCChart));
        jCChartStyle.parent = jCChart == null ? null : jCChart.chartArea;
        return jCChartStyle;
    }

    public JCLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public synchronized void setLineStyle(JCLineStyle jCLineStyle) {
        if (this.lineStyle == jCLineStyle) {
            return;
        }
        this.lineStyle = jCLineStyle;
        this.lineStyle.parent = this;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public int getLinePattern() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getPattern();
    }

    public void setLinePattern(int n) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setPattern(n);
    }

    public int getLineWidth() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getWidth();
    }

    public synchronized void setLineWidth(int n) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setWidth(n);
    }

    public Color getLineColor() {
        if (this.lineStyle == null) {
            return null;
        }
        return this.lineStyle.getColor();
    }

    public synchronized void setLineColor(Color color) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setColor(color);
    }

    public JCSymbolStyle getSymbolStyle() {
        return this.symbolStyle;
    }

    public synchronized void setSymbolStyle(JCSymbolStyle jCSymbolStyle) {
        if (this.symbolStyle == jCSymbolStyle) {
            return;
        }
        this.symbolStyle = jCSymbolStyle;
        this.symbolStyle.parent = this;
    }

    public int getSymbolShape() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getShape();
    }

    public synchronized void setSymbolShape(int n) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setShape(n);
    }

    public Color getSymbolColor() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getColor();
    }

    public synchronized void setSymbolColor(Color color) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setColor(color);
    }

    public int getSymbolSize() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getSize();
    }

    public void setSymbolSize(int n) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setSize(n);
    }

    public JCShape getSymbolCustomShape() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getCustomShape();
    }

    public synchronized void setSymbolCustomShape(JCShape jCShape) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setCustomShape(jCShape);
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public synchronized void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle == jCFillStyle) {
            return;
        }
        this.fillStyle = jCFillStyle;
        this.fillStyle.parent = this;
        if (this.parent != null) {
            this.parent.setChanged(true);
        }
    }

    public Color getFillColor() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getColor();
    }

    public synchronized void setFillColor(Color color) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setColor(color);
    }

    public int getFillPattern() {
        if (this.fillStyle == null) {
            return 0;
        }
        return this.fillStyle.getPattern();
    }

    public synchronized void setFillPattern(int n) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setPattern(n);
    }

    public Image getFillImage() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getImage();
    }

    public synchronized void setFillImage(Image image) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setImage(image);
    }

    public static void resetDefaults() {
        JCFillStyle.defaultColorIndex = 0;
        JCLineStyle.defaultColorIndex = 0;
        JCSymbolStyle.defaultColorIndex = 0;
    }
}

